# Tracker platform
An advanced URL shortener platform for tracking/monitoring links traffic with gorgeous insights/stats.<br>
(Fully Django Adminsite/dashboard customized)

## Index:
* [Features](#features)<br>
* [Used Technologies](#technologies)<br>
* [Demo](#demo)<br>
* [Installation](#installation)<br>
    * [Using Docker](#docker-installation)<br>
    * [Manual installation](#manual-installation)<br>


## Features:
This platform supports:
- Custom domains.
- Multi-redirections based on devices (Mobile/Desktop/Tablet), OS (Windows/Linux/MacOs/Android/iOS) and countries.
- Advanced insights/stats per link.
- Supports users & groups managements.
- Link protection via password.
- Fully Django Adminsite/dashboard customized.
- And a lot more...

## <a name="technologies" >Used Technologies:</a>
Django, Webpack, Docker, Bootstrap.
HTML, CSS/SASS, Javascript, Python, Nodejs, Linux, Bash.


## Demo
```
https://dotracker-demo.mr4web.com
https://dotracker-demo.mr4web.com/account/login/

Admin credencials:
Email: admin@test.com
Pass: 123456
```


## Installation:
### <a name="docker-installation">Using Docker:</a>
```
docker run -it --name tracker -p 8000:80 -e DEBUG=1 -e ALLOWED_HOSTS='*' -d mrmed/tracker
```
To apply migrations, seeds and collectstatic files:
```
docker exec -it tracker sh /app/docker_install.sh 
```

To create superuser account:
```
docker exec -it tracker python3 manage.py createsuperuser
```
Restart your server (required):
```
docker container restart tracker
```

### <a name="manual-installation">Manual installation:</a>
```bash
# create a folder and clone this github repo.
git clone https://github.com/medram/project_2.git && cd project_2

# create .env file
cp -pv .env.example .env

# create an environment
python3 -m venv venv
source venv/bin/activate

pip install -r requirements.txt --no-cache-dir

# Applying migrations
python3 manage.py migrate

# Applying seeds
python3 manage.py loaddata app/seeds/settings.json
python3 manage.py loaddata app/seeds/pages.json
python3 manage.py loaddata app/seeds/admin_interface.json

# Handling assets/static files
python3 manage.py collectstatic --no-input --skip-checks

# Server restart is required!
```

Then browse this:
```
http://127.0.0.1:8000/
```
or use your domain:
```
http://your-domain.com:8000/
```


